<?php

/**
 * @file
 * Administrative page callbacks for the aframe module.
 */

/**
 * Implements hook_admin_settings().
 *
 * Implements for module settings configuration.
 */
function aframe_admin_settings_form($form_state) {
  $form['aframe_library'] = array(
    '#title' => t('A-frame library'),
    '#type' => 'textfield',
    '#default_value' => variable_get('aframe_library'),
    '#required' => TRUE,
    '#description' => t('Get library url from aframe.io. Eg: https://aframe.io/releases/0.4.0/aframe.min.js'),
  );

  $form['aframe_path'] = array(
    '#title' => t('Path'),
    '#type' => 'textarea',
    '#default_value' => variable_get('aframe_path'),
    '#required' => TRUE,
    '#description' => t('Add paths where aframe will be used. Eg: project/*. One path per line.'),
  );

  return system_settings_form($form);
}
