<?php

/**
 * @file
 * Definition of variables for Variable API module.
 */

/**
 * Implements hook_variable_info().
 */
function aframe_variable_info($options) {
  $variables['aframe_library'] = array(
    'type' => 'string',
    'title' => t('Library url', array(), $options),
    'default' => '',
    'description' => t('Get library url from https://aframe.io'),
    'required' => TRUE,
    'group' => 'aframe',
    'localize' => FALSE,
    'multidomain' => TRUE,
  );

  $variables['aframe_path'] = array(
    'type' => 'string',
    'title' => t('Enable on path', array(), $options),
    'default' => '',
    'group' => 'aframe',
    'localize' => FALSE,
  );

  return $variables;
}

/**
 * Implements hook_variable_group_info().
 */
function aframe_variable_group_info() {
  $groups['aframe'] = array(
    'title' => t('A-frame'),
    'description' => t('Configure library url and paths where aframe is used.'),
    'access' => 'administer aframe',
    'path' => array('admin/config/system/aframe'),
  );

  return $groups;
}
