<?php

/**
 * This is ATOM 1.0 parsing callback function
 */
function _aggregation_ATOM10_parse($feed_XML, $feed)
{
	foreach ($feed_XML->entry AS $key => $news)
	{
		$news = (array)$news;

		if ($news['id'])
			$guid = $news['id'];
		else
			$guid = NULL;
			
		$additional_taxonomies = array();
			
		if ($news['category'])
		{
			$additional_taxonomies['ATOM Categories'] = array();
			foreach ($news['category'] AS $category)
				$additional_taxonomies['ATOM Categories'][] = (string)$category['term'];
		}
			
		$title = $news['title'];
		if ($news['content']['src'])
		{
			$body = $news['summary'];
			$original_url = (string)$news['content']['src'];
		}
			
		if ($news['summary'])
			$teaser = $news['summary'];
		else
			$teaser = node_teaser($body);
		
		$author_found = FALSE;
			
		if ($news['author'])
		{
			$item_author = $news['author'];
			$original_author = (string)$item_author->name;
			$author_found = TRUE;
		}
		else if ($news['source'])
		{
			$item_source = (array)$news['source'];
			if ($item_source['author'])
			{
				$item_author = $item_source['author'];
				$original_author = (string)$item_author->name;
				$author_found = TRUE;				
			}
		}
		
		if ($feed_XML->author && !$author_found)
		{	
			$original_author = $feed_XML->author;
			$original_author = (array)$original_author;
			
			if ($original_author['name']) 
				$original_author = (string)$original_author['name'];
			else 
				$original_author = $feed->original_author;
		}
		else if (!$author_found)
			$original_author = $feed->original_author;
		
		if ($news['link'])
		{
			$link = $news['link'];
			
			if ($link['href'])
				$original_url = (string)$link['href'];
			else
				$original_url = NULL;
		}
		else 
			$original_url = NULL;
			
		$timestamp = strtotime($news['issued']);
		if ($timestamp === FALSE)
			$timestamp = time();
			
		_aggregation_add_item($title, $body, $teaser, $original_author, $feed, $additional_taxonomies, $timestamp, $original_url, $guid, array());
	}
}