<?php

/**
 * This is RSS 2.0 parsing callback function
 */
function _aggregation_RSS20_parse($feed_XML, $feed)
{
	foreach ($feed_XML->xpath('//item') AS $news)
	{
		$news = (array)$news;
		
		if ($news['guid'])
			$guid = $news['guid'];
		else
			$guid = NULL;
			
		if ($news['title'])
			$title = $news['title'];
		else 
			$title = '';
		
		if ($news['description'])
			$body = $news['description'];
		else
			$body = $news['title'];
			
		$teaser = node_teaser($body);
		
		if ($feed_XML->channel->title)
			$original_author = (string)$feed_XML->channel->title;
		else
			$original_author = $feed->original_author;
		
		if ($news['link'])
			$original_url = $news['link'];
		else 
			$original_url = NULL;
			
		$timestamp = strtotime($news['pubDate']);
		if ($timestamp === FALSE)
			$timestamp = time();
			
		$additional_taxonomies = array();
		
		if ($news['category'] && !empty($news['category']))
		{
			if (is_array($news['category'])) $news['category'] = $news['category'][0];
			$additional_taxonomies['RSS Categories'] = explode('/', $news['category']);
		}
			
		_aggregation_add_item($title, $body, $teaser, $original_author, $feed, $additional_taxonomies, $timestamp, $original_url, $guid, array());
	}
}