/**
 * Behavior for 'aggrid_widget_type' widget.
 */
(function ($) {
    'use strict';

    Drupal.aggridInstances = [];


    Drupal.behaviors.aggridIntegration = {
        attach: function (context) {

            // @todo Init functionality should support multiple drop zones on page.
            var selector = $('.aggrid-widget');

            var aggridFieldName = selector.data('target');
            var aggridLicense = selector.data('license');
            var aggridDataEdit = selector.data('edit') != undefined ? selector.data('edit') : false;

            selector.addClass('aggrid');

            $(selector)
                .css('height', '500px');

            // If DropzoneJS instance is already registered on Element. There is no
            // need to register it again.
            if (selector.once('.aggrid-widget').length !== selector.length) {
                return;
            }

            var targetValue = $('#' + aggridFieldName).val();
            var aggridJSON = targetValue ? JSON.parse(targetValue) : null;

            function makeJson() {
                var aggridOutput = {};
                aggridOutput.rowData = gridOptions.rowData;
                aggridOutput.columnDefs = gridOptions.columnDefs;

                $('#' + aggridFieldName).val(JSON.stringify(aggridOutput));
            }

            function formatNumber(number) {
                // this puts commas into the number eg 1000 goes to 1,000,
                // i pulled this from stack overflow, i have no idea how it works
                return Math.floor(number).toString().replace(/(\d)(?=(\d{3})+(?!\d))/g, "$1,");
            }

            var default_gridOptions = {
                stopEditingWhenGridLosesFocus: true,
                defaultColDef: {
                    editable: aggridDataEdit,
                },
                onGridReady: function () {
                    gridOptions.api.sizeColumnsToFit();
                },
                onCellValueChanged: function() {
                    makeJson();
                }
            };

            var gridOptions = aggridJSON;
            gridOptions = Object.assign(aggridJSON, default_gridOptions);
            //colDef.menuTabs: ['filterMenuTab','columnsMenuTab'],
            var eGridDiv = document.querySelector('.aggrid-widget');

            if (aggridLicense != ''){
                agGrid.LicenseManager.setLicenseKey("Evaluation_License_Valid_Until_4_July_2018__MTUzMDY1ODgwMDAwMA==e5bda1e1a8dc6e37ae41df70aeaffb86");
            }
            
            // create the grid passing in the div to use together with the columns & data we want to use
            new agGrid.Grid(eGridDiv, gridOptions);

        }
    }

})(jQuery);
