<?php

namespace Drupal\aggrid\Entity;

use Drupal\Core\Config\Entity\ConfigEntityBase;

/**
 * Defines the ag-Grid Entity entity.
 *
 * @ConfigEntityType(
 *   id = "aggrid",
 *   label = @Translation("ag-Grid"),
 *   handlers = {
 *     "view_builder" = "Drupal\Core\Entity\EntityViewBuilder",
 *     "list_builder" = "Drupal\aggrid\aggridListBuilder",
 *     "form" = {
 *       "add" = "Drupal\aggrid\Form\aggridForm",
 *       "edit" = "Drupal\aggrid\Form\aggridForm",
 *       "delete" = "Drupal\aggrid\Form\aggridDeleteForm"
 *     },
 *     "route_provider" = {
 *       "html" = "Drupal\aggrid\aggridHtmlRouteProvider",
 *     },
 *   },
 *   config_prefix = "aggrid",
 *   admin_permission = "administer site configuration",
 *   entity_keys = {
 *     "id" = "id",
 *     "label" = "label"
 *   },
 *   links = {
 *     "canonical" = "/admin/structure/aggrid/{aggrid}",
 *     "add-form" = "/admin/structure/aggrid/add",
 *     "edit-form" = "/admin/structure/aggrid/{aggrid}/edit",
 *     "delete-form" = "/admin/structure/aggrid/{aggrid}/delete",
 *     "collection" = "/admin/structure/aggrid"
 *   }
 * )
 */
class aggrid extends ConfigEntityBase implements aggridInterface {

  /**
   * The ag-Grid ID.
   *
   * @var string
   */
  protected $id;

  /**
   * The ag-Grid label.
   *
   * @var string
   */
  protected $label;

  /**
   * The ag-Grid Default JSON.
   *
   * @var string
   */
  protected $aggridDefault;

  /**
   * The ag-Grid additional options.
   *
   * @var string
   */
  protected $addOptions;

}
