<?php

namespace Drupal\aggrid\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Class General.
 */
class GeneralSettingsForm extends ConfigFormBase {

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames() {
    return [
      'aggrid.general',
    ];
  }

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'general';
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    $config = $this->config('aggrid.general');
    $form['version'] = [
      '#type' => 'radios',
      '#title' => $this->t('Version'),
      '#description' => $this->t('The free and open version of ag-Grid'),
      '#options' => ['Community' => $this->t('Community'), 'Enterprise' => $this->t('Enterprise')],
      '#default_value' => $config->get('version'),
    ];
    $form['license_key'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Enterprise License Key'),
      '#description' => $this->t('Required for using the Enterprise version.'),
      '#default_value' => $config->get('license_key'),
    ];
    return parent::buildForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function validateForm(array &$form, FormStateInterface $form_state) {
    parent::validateForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    parent::submitForm($form, $form_state);

    $this->config('aggrid.general')
      ->set('version', $form_state->getValue('version'))
      ->set('license_key', $form_state->getValue('license_key'))
      ->save();
  }

}
