<?php

namespace Drupal\aggrid\Plugin\Field\FieldFormatter;

use Drupal\Component\Utility\Html;
use Drupal\Core\Field\FieldItemInterface;
use Drupal\Core\Field\FieldItemListInterface;
use Drupal\Core\Field\FormatterBase;
use Drupal\Core\Form\FormStateInterface;
use Drupal\aggrid\Entity;
use Drupal\Core\Form\ConfigFormBase;

/**
 * Plugin implementation of the 'aggrid_formatter_type' formatter.
 *
 * @FieldFormatter(
 *   id = "aggrid_formatter_type",
 *   label = @Translation("Aggrid formatter type"),
 *   field_types = {
 *     "aggrid"
 *   }
 * )
 */
class aggridFormatterType extends FormatterBase {

  /**
   * {@inheritdoc}
   */
  public static function defaultSettings() {
    return [
      // Implement default settings.
    ] + parent::defaultSettings();
  }

  /**
   * {@inheritdoc}
   */
  public function settingsForm(array $form, FormStateInterface $form_state) {
    return [
      // Implement settings form.
    ] + parent::settingsForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function settingsSummary() {
    $summary = [];
    // Implement settings summary.

    return $summary;
  }

  /**
   * {@inheritdoc}
   */
  public function viewElements(FieldItemListInterface $items, $langcode) {
    $elements = [];
/*
    foreach ($items as $delta => $item) {
      $elements[$delta] = ['#markup' => $this->viewValue($item)];
    }
*/

    foreach ($items as $delta => $item) {
      $config = \Drupal::config('aggrid.general');
      $field_settings = $this->getFieldSettings();

      $field_name = $this->fieldDefinition->getName();

      $item_id = Html::getUniqueId("ht-$field_name-$delta");

      $elements[$delta]['container'] = [
        '#suffix' => '<div class="aggrid-widget ag-theme-balham" id="' . $item_id . '_aggrid" data-license="'. $config->get('license_key') .'" data-edit="false" data-target="' . $item_id . '"></div>',
        '#attributes' => ['class' => ['aggrid-widget']],
        '#attached' => [
          'library' => [
            'aggrid/widget',
          ],
        ],
      ];

      if ($config->get('version') == "Enterprise") {
        array_push($elements[$delta]['container']['#attached']['library'], 'aggrid/ag-grid-enterprise');
      } else {
        array_push($elements[$delta]['container']['#attached']['library'], 'aggrid/ag-grid');
      }

      if (isset($items[$delta]->aggrid_id)) {
        $aggridEntity = Entity\aggrid::load($items[$delta]->aggrid_id);

        if ($items[$delta]->value != '') {
          $aggridValue = trim($items[$delta]->value);
        } else {
          $aggridValue = trim($aggridEntity->get('aggridDefault'));
        }
        $aggridValue = substr($aggridValue, 0, strlen($aggridValue) - 1);
        if ($aggridEntity->get('addOptions') != '') {
          $aggridValue .= ', ' . $aggridEntity->get('addOptions');
        }
        $aggridValue .= '}';
      } else {
        $aggridValue = $items[$delta]->value;
      }

      $elements[$delta]['value'] = [
        '#type' => 'hidden',
        '#attributes' => ['id' => [$item_id]],
        '#value' => $aggridValue,
      ];

    }

    return $elements;
  }

  /**
   * Generate the output appropriate for one field item.
   *
   * @param \Drupal\Core\Field\FieldItemInterface $item
   *   One field item.
   *
   * @return string
   *   The textual output generated.
   */
  protected function viewValue(FieldItemInterface $item) {
    // The text value has no text format assigned to it, so the user input
    // should equal the output, including newlines.
    return nl2br(Html::escape($item->value));
  }

}
