<?php

namespace Drupal\aggrid\Plugin\Field\FieldWidget;

use Drupal\Core\Field\FieldItemListInterface;
use Drupal\Core\Field\WidgetBase;
use Drupal\Core\Form\FormStateInterface;
use Drupal\Component\Utility\Html;
use Drupal\aggrid\Entity;
use Drupal\Core\Form\ConfigFormBase;

/**
 * Plugin implementation of the 'aggrid' widget.
 *
 * @FieldWidget(
 *   id = "aggrid_widget_type",
 *   label = @Translation("ag-Grid"),
 *   field_types = {
 *     "aggrid"
 *   }
 * )
 */
class aggridWidgetType extends WidgetBase {

  /**
   * {@inheritdoc}
   */
  public function settingsSummary() {
    $summary = [];
    /*\\
    $summary[] = t('Textfield size: @size', ['@size' => $this->getSetting('size')]);
    if (!empty($this->getSetting('placeholder'))) {
      $summary[] = t('Placeholder: @placeholder', ['@placeholder' => $this->getSetting('placeholder')]);
    }
    */
    return $summary;
  }

  /**
   * {@inheritdoc}
   */
  public function formElement(FieldItemListInterface $items, $delta, array $element, array &$form, FormStateInterface $form_state)
  {
    $config = \Drupal::config('aggrid.general');
    //$field_settings = $this->getFieldSettings();
    //$settings = $this->getSettings();

    $field_name = $this->fieldDefinition->getName();

    $item_id = Html::getUniqueId("ht-$field_name-$delta");

    if (isset($form['#parents'][0]) && $form['#parents'][0] == 'default_value_input') {

      $options = [];

      $aggridEntities = \Drupal::entityManager()->getStorage('aggrid')->loadMultiple();

      foreach ($aggridEntities as $aggridEntity) {
        $options[$aggridEntity->id()] = $aggridEntity->label();
      }

      $element['aggrid_id'] = [
        '#type' => 'select',
        '#empty_option' => t(' - Select - '),
        '#options' => $options,
        '#title' => t('ag-Grid Default Config Entity'),
        '#description' => t('Choose ag-Grid Config Entity for Default. *Once saved, this cannot be modified.'),
        '#default_value' => isset($items[$delta]->aggrid_id) ? $items[$delta]->aggrid_id : NULL,
        '#required' => TRUE,
        '#disabled' => isset($items[$delta]->aggrid_id),
      ];

      $widget['value'] = [
        '#type' => 'hidden',
        '#attributes' => ['id' => [$item_id]],
        '#default_value' => NULL,
      ];

    } else {

      $element['container'] = [
        '#suffix' => '<div class="aggrid-widget ag-theme-balham" id="' . $item_id . '_aggrid" data-license="'. $config->get('license_key') .'" data-edit="true" data-target="' . $item_id . '"></div>',
        '#attributes' => ['class' => ['aggrid-widget']],
        '#attached' => [
          'library' => [
            'aggrid/widget',
          ],
        ],
      ];

      if ($config->get('version') == "Enterprise") {
        array_push($element['container']['#attached']['library'], 'aggrid/ag-grid-enterprise');
      } else {
        array_push($element['container']['#attached']['library'], 'aggrid/ag-grid');
      }

      if (isset($items[$delta]->aggrid_id)) {
        $aggridEntity = Entity\aggrid::load($items[$delta]->aggrid_id);

        if ($items[$delta]->value != '') {
          $aggridValue = trim($items[$delta]->value);
        } else {
          $aggridValue = trim($aggridEntity->get('aggridDefault'));
        }
        $aggridValue = substr($aggridValue, 0, strlen($aggridValue) - 1);
        if ($aggridEntity->get('addOptions') != '') {
          $aggridValue .= ', ' . $aggridEntity->get('addOptions');
        }
        $aggridValue .= '}';
      } else {
        $aggridValue = $items[$delta]->value;
      }

      $widget['value'] = [
        '#type' => 'hidden',
        '#attributes' => ['id' => [$item_id]],
        '#default_value' => $aggridValue,
      ];

      $widget['aggrid_id'] = [
        '#type' => 'hidden',
        '#default_value' => isset($items[$delta]->aggrid_id) ? $items[$delta]->aggrid_id : NULL,
      ];

    }

    $element = $element + $widget;
    return $element;
  }

}
