<?php
/**
 * @file
 * Features integration for the Metatag module.
 */

/**
 * Implements hook_features_export().
 */
function metatag_features_export($data, &$export, $module_name = '', $type = 'metatag') {
  $pipe = array();

  foreach ($data as $name) {
    $export['features'][$type][$name] = metatag_config_load($name);
  }

  $export['dependencies']['metatag'] = 'metatag';

  return $pipe;
}

/**
 * Implements hook_features_export_render().
 */
function metatag_features_export_render($module_name, $data, $export = NULL) {
  $code = array();
  $code[] = '  $config = array();';
  $code[] = '';

  foreach ($data as $key => $name) {
    if (is_object($name)) {
      $name = $name->instance;
    }
    if ($config = metatag_config_load($name)) {
      $export = new stdClass();
      $export->instance = $config->instance;
      $export->config = $config->config;
      $export = features_var_export($export, '  ');
      $key = features_var_export($name);
      $code[] = "  // Exported Metatag config instance: {$name}.";
      $code[] = "  \$config[{$key}] = {$export};";
      $code[] = "";
    }
  }
  $code[] = '  return $config;';
  $code = implode("\n", $code);
  return array('metatag_export_default' => $code);
}

/**
 * Implements hook_features_revert().
 */
function metatag_features_revert($module) {
  $function = "{$module}_metatag_export_default";
  $feature_conf = $function();
  if ($default_config = features_get_default('metatag')) {
    foreach (array_keys($default_config) as $config) {
      if ($conf = metatag_config_load($config)) {
        db_delete('metatag_config')->condition('instance', $config)->execute();
      }
      unset($feature_conf[$config]['cid']);
      $object = new stdClass();
      $object->cid = NULL;
      $object->instance = $config;
      $object->config = $feature_conf[$config]['config'];
      metatag_config_save($object);
    }
  }
}

/**
 * Implements hook_features_export_options().
 */
function metatag_features_export_options() {
  $instances = metatag_config_instance_info();
  foreach ($instances as $key => $instance) {
    $options[$key] = $key;
  };
  return $options;
}
