<?php

/**
 * @file
 * CCK Field for Ukrainian phone numbers.
 */

/**
 * Helper function knows all valid country codes.
 *
 * @return array of stings for use in preg_match* fuunctions.
 *
 * Return PREG string elements in array like "44\d{7}|278\d{6}" which will match
 * all nine-digit valid numbers.
 * Please note - leading zero stripped for both mobile and landline.
 *
 * For performance reason there are a set of strings instead of single very long one.
 */
function _phone_ua_get_valid_masks() {
  $result = cache_get('phone' . __FUNCTION__);

  if( !empty($result) ) {
    return $result->data;
  }

  $mobiles = array(
    "39",
    "50",
    "63",
    "66",
    "67",
    "68",
    "91",
    "92",
    "93",
    "94",
    "95",
    "96",
    "97",
    "98",
    "99",
  );

  $landlines = array(
    "255",
    "260",
    "263",
    "265",
    "268",
    "269",
    "271",
    "272",
    "278",
    "312",
    "3131",
    "3132",
    "3133",
    "3134",
    "3135",
    "3136",
    "3137",
    "3141",
    "3142",
    "3143",
    "3144",
    "3145",
    "3146",
    "322",
    "3230",
    "3231",
    "3234",
    "3236",
    "3238",
    "3239",
    "3241",
    "3244",
    "3245",
    "3247",
    "3248",
    "3249",
    "3251",
    "3252",
    "3254",
    "3255",
    "3256",
    "3257",
    "3259",
    "32606",
    "3261",
    "3263",
    "3264",
    "3265",
    "3266",
    "3269",
    "3310",
    "3322",
    "3342",
    "3344",
    "3346",
    "3348",
    "3352",
    "3355",
    "3357",
    "3362",
    "3363",
    "3365",
    "3366",
    "3368",
    "3372",
    "3374",
    "3376",
    "3377",
    "3379",
    "342",
    "3430",
    "3431",
    "3432",
    "3433",
    "3434",
    "3435",
    "3436",
    "3438",
    "3471",
    "3472",
    "3474",
    "3475",
    "3476",
    "3477",
    "3478",
    "3479",
    "352",
    "3540",
    "3541",
    "3542",
    "3543",
    "3544",
    "3546",
    "3547",
    "3548",
    "3549",
    "3550",
    "3551",
    "3552",
    "3554",
    "3555",
    "3557",
    "3558",
    "362",
    "3632",
    "3633",
    "3634",
    "3635",
    "3636",
    "3637",
    "3650",
    "3651",
    "3652",
    "3653",
    "3654",
    "3655",
    "3656",
    "3657",
    "3658",
    "3659",
    "372",
    "373",
    "3740",
    "3741",
    "382",
    "384",
    "385",
    "412",
    "4130",
    "4132",
    "4133",
    "4134",
    "4135",
    "4136",
    "4137",
    "4138",
    "4139",
    "414",
    "4161",
    "4162",
    "4231",
    "4232",
    "4241",
    "432",
    "4330",
    "4331",
    "4332",
    "4333",
    "4334",
    "4335",
    "4336",
    "4337",
    "43388",
    "4340",
    "4341",
    "4342",
    "4343",
    "4344",
    "4345",
    "4346",
    "4347",
    "4348",
    "4349",
    "4350",
    "4351",
    "4352",
    "4353",
    "4355",
    "4356",
    "4357",
    "4358",
    "44",
    "462",
    "4631",
    "4632",
    "4633",
    "4634",
    "4635",
    "4636",
    "4637",
    "4641",
    "4642",
    "4643",
    "4644",
    "4645",
    "4646",
    "4653",
    "4654",
    "4655",
    "4656",
    "4657",
    "4658",
    "4659",
    "472",
    "473",
    "4740",
    "4741",
    "4742",
    "4744",
    "4745",
    "4746",
    "4747",
    "4748",
    "4749",
    "482",
    "484",
    "4851",
    "4852",
    "4853",
    "4854",
    "4855",
    "4856",
    "4857",
    "4858",
    "4859",
    "4860",
    "4861",
    "4862",
    "4863",
    "4864",
    "4865",
    "4866",
    "4867",
    "4868",
    "512",
    "5131",
    "5132",
    "5133",
    "5134",
    "5135",
    "5136",
    "5151",
    "5152",
    "5153",
    "5154",
    "5158",
    "5159",
    "5161",
    "5162",
    "5163",
    "5167",
    "5168",
    "522",
    "5233",
    "5234",
    "5235",
    "5236",
    "5237",
    "5238",
    "5239",
    "5240",
    "5241",
    "5242",
    "5250",
    "5251",
    "5252",
    "5253",
    "5254",
    "5256",
    "5257",
    "5258",
    "5259",
    "532",
    "5340",
    "5341",
    "5342",
    "5343",
    "5344",
    "5345",
    "5346",
    "5347",
    "5348",
    "5350",
    "5351",
    "5352",
    "5353",
    "5354",
    "5355",
    "5356",
    "5357",
    "5358",
    "5359",
    "536",
    "5361",
    "5362",
    "5363",
    "5364",
    "5365",
    "5366",
    "542",
    "5422",
    "5442",
    "5443",
    "5444",
    "5445",
    "5446",
    "5447",
    "5448",
    "5449",
    "5451",
    "5452",
    "5453",
    "5454",
    "5455",
    "5456",
    "5457",
    "5458",
    "5459",
    "552",
    "553",
    "5542",
    "5543",
    "5544",
    "5545",
    "5546",
    "5547",
    "5548",
    "5549",
    "56",
    "5610",
    "5611",
    "5612",
    "5615",
    "5616",
    "5617",
    "5618",
    "562",
    "5630",
    "5632",
    "5633",
    "5636",
    "5638",
    "5639",
    "564",
    "5650",
    "5651",
    "5652",
    "5653",
    "5655",
    "5656",
    "5657",
    "5658",
    "5662",
    "5663",
    "5665",
    "5667",
    "5668",
    "567",
    "569",
    "572",
    "574",
    "575",
    "5761",
    "5762",
    "5763",
    "5764",
    "5765",
    "5766",
    "612",
    "6131",
    "6132",
    "6133",
    "6136",
    "6137",
    "6138",
    "6139",
    "6140",
    "6141",
    "6142",
    "6143",
    "6144",
    "6145",
    "6147",
    "6153",
    "6156",
    "6162",
    "6165",
    "6175",
    "6178",
    "619",
    "6212",
    "6214",
    "6217",
    "622",
    "6232",
    "6236",
    "6237",
    "6239",
    "6242",
    "6243",
    "6244",
    "6246",
    "6247",
    "6249",
    "6250",
    "6252",
    "6253",
    "6254",
    "6255",
    "6256",
    "6257",
    "6259",
    "6261",
    "6262",
    "6264",
    "6267",
    "6269",
    "6272",
    "6273",
    "6274",
    "6275",
    "6277",
    "6278",
    "6279",
    "629",
    "642",
    "6431",
    "6432",
    "6433",
    "6434",
    "6435",
    "6436",
    "6441",
    "6442",
    "6443",
    "6444",
    "6445",
    "6446",
    "6451",
    "6452",
    "6453",
    "6454",
    "6455",
    "6456",
    "6461",
    "6462",
    "6463",
    "6464",
    "6465",
    "6466",
    "6471",
    "6472",
    "6473",
    "6474",
    "652",
    "654",
    "655",
    "6560",
    "6561",
    "6562",
    "6563",
    "6564",
    "6565",
    "6566",
    "6569",
    "692",
  );

  $all_codes = array_merge($mobiles, $landlines);

  $TOTAL_DIGITS = 9;
  $ITEMS_PER_LINE = 30;
  $counter = 0;
  $line = '';
  foreach ($all_codes as $code) {
    if (++$counter >= $ITEMS_PER_LINE) {
      $result[] = $line;
      $counter = 0;
      $line = '';
    }
    $item = $code . '\d{' . ($TOTAL_DIGITS - strlen($code)) . '}';
    $line .= (empty($line) ? '' : '|') . $item;
  }
  $result[] = $line;

  cache_set('phone' . __FUNCTION__, $result);
  return $result;

}

function phone_ua_metadata() {
  // These strings are translated using t() on output.
  return array(
    'error' => '"%value" is not a valid Ukrainian mobile phone number<br />'
      . 'Ukrainian phone numbers should only have 10 digits staring with 0 with optional country prefix +38 .<br />'
      . 'And, of course, city or mobile code - a first few digits after 0 - have to be valid.',
  );
}

/**
 * Verifies that $phonenumber is valid
 *
 * @param string $phonenumber
 * @return boolean Returns boolean FALSE if the phone number is not valid.
 */
function valid_ua_phone_number($phonenumber) {
  // For adressing Ukraine phones used both +38 and +380 as a prefix.
  // So lets clean up any spaces, pareenthesis, minus signs etc first.
  $cleaning_pattern = '/( |\-|\(|\))*/';
  $refined_phonenumber = preg_replace($cleaning_pattern, '', $phonenumber);

  // define regular expression
  $code_packs = _phone_ua_get_valid_masks();
  foreach ($code_packs as $codes) {
    // $regex = "/^((8|\+38)-?)?\s*(\(?044\)?)?-?\d{3}-?\d{2}-?\d{2}$/i";
    // Please note - pure 8 as a prefix is obsolete.
    $regex = "/^(\+38)?0(" . $codes . ")$/";
    if (preg_match($regex, $refined_phonenumber)) {
      return true;
    }
  }

  // return true if valid, false otherwise
  return false;
}

/**
 * Formatting for Unkraine Phone Numbers.
 *
 * @param string $phonenumber
 * @return string Returns a string containting the phone number with some formatting.
 */
function format_ua_phone_number($phonenumber, $field) {

  //$phonenumber = trim($phonenumber);

   // do some formatting on the phone number

/* ==> to be done ==> add the country code
   if ($field['phone_country_code']) {
      if ($matches[1] != "+39") {
  	$phonenumber = "+39" . " " . $phonenumber;
      }
   }
*/
   return $phonenumber;
}
