<?php

/**
 * @file
 * Contains \Drupal\entity_browser\Annotation\EntityBrowserWidgetSelector.
 */

namespace Drupal\entity_browser\Annotation;

use Drupal\Component\Annotation\Plugin;

/**
 * Defines an entity browser widget selector annotation object.
 *
 * @see hook_entity_browser_widget_selector_info_alter()
 *
 * @Annotation
 */
class EntityBrowserWidgetSelector extends Plugin {

  /**
   * The plugin ID.
   *
   * @var string
   */
  public $id;

  /**
   * The human-readable name of the widget selector.
   *
   * @ingroup plugin_translatable
   *
   * @var \Drupal\Core\Annotation\Translation
   */
  public $label;

  /**
   * A brief description of the widget selector.
   *
   * This will be shown when adding or configuring this widget selector.
   *
   * @ingroup plugin_translatable
   *
   * @var \Drupal\Core\Annotation\Translation (optional)
   */
  public $description = '';

}
