<?php

/**
 * @file
 * Contains \Drupal\pathauto\Tests\PathautoUiTest.
 */

namespace Drupal\pathauto\Tests;

use Drupal\simpletest\WebTestBase;

/**
 * Test basic pathauto functionality.
 *
 * @group pathauto
 */
class PathautoUiTest extends WebTestBase {

  use PathautoTestHelperTrait;

  /**
   * Modules to enable.
   *
   * @var array
   */
  public static $modules = array('pathauto', 'node');

  /**
   * Admin user.
   *
   * @var \Drupal\user\UserInterface
   */
  protected $adminUser;

  /**
   * {inheritdoc}
   */
  function setUp() {
    parent::setUp();

    $this->drupalCreateContentType(array('type' => 'page', 'name' => 'Basic page'));
    $this->drupalCreateContentType(array('type' => 'article'));

    // Allow other modules to add additional permissions for the admin user.
    $permissions = array(
      'administer pathauto',
      'administer url aliases',
      'create url aliases',
      'administer nodes',
      'bypass node access',
      'access content overview',
    );
    $this->adminUser = $this->drupalCreateUser($permissions);
    $this->drupalLogin($this->adminUser);
  }

  function testSettingsValidation() {
    $edit = array();
    $edit['max_length'] = 'abc';
    $edit['max_component_length'] = 'abc';
    $this->drupalPostForm('admin/config/search/path/settings', $edit, 'Save configuration');
    /*$this->assertText('The field Maximum alias length is not a valid number.');
    $this->assertText('The field Maximum component length is not a valid number.');*/
    $this->assertNoText('The configuration options have been saved.');

    $edit['max_length'] = '0';
    $edit['max_component_length'] = '0';
    $this->drupalPostForm('admin/config/search/path/settings', $edit, 'Save configuration');
    /*$this->assertText('The field Maximum alias length cannot be less than 1.');
    $this->assertText('The field Maximum component length cannot be less than 1.');*/
    $this->assertNoText('The configuration options have been saved.');

    $edit['max_length'] = '999';
    $edit['max_component_length'] = '999';
    $this->drupalPostForm('admin/config/search/path/settings', $edit, 'Save configuration');
    /*$this->assertText('The field Maximum alias length cannot be greater than 255.');
    $this->assertText('The field Maximum component length cannot be greater than 255.');*/
    $this->assertNoText('The configuration options have been saved.');

    $edit['max_length'] = '50';
    $edit['max_component_length'] = '50';
    $this->drupalPostForm('admin/config/search/path/settings', $edit, 'Save configuration');
    $this->assertText('The configuration options have been saved.');
  }

  function testPatternsValidation() {
    // Try to save an invalid pattern.
    $this->drupalGet('admin/config/search/path/patterns/add');
    $edit = array(
      'type' => 'canonical_entities:node',
    );
    $this->drupalPostAjaxForm(NULL, $edit, 'type');
    $edit += array(
      'pattern' => '[node:title]/[user:name]/[term:name]',
      'bundles[page]' => TRUE,
      'label' => 'Page pattern',
      'id' => 'page_pattern',
    );
    $this->drupalPostForm(NULL, $edit, 'Save');
    $this->assertText('The Path pattern is using the following invalid tokens: [user:name], [term:name].');
    $this->assertNoText('The configuration options have been saved.');

    // Fix the pattern, then check that it gets saved successfully.
    $edit['pattern'] = '[node:title]';
    $this->drupalPostForm(NULL, $edit, 'Save');
    $this->assertText('Pattern Page pattern saved.');
  }

}
