<?php

/**
 * @file
 * Agreement module post-updates.
 */

use Drupal\Core\Config\Entity\ConfigEntityUpdater;

/**
 * Fixes translatable schema types from "string" to "label".
 */
function agreement_post_update_fix_translatable_schema(&$sandbox = NULL) {
  if (\Drupal::moduleHandler()->moduleExists('agreement')) {
    // Saving each agreement should be enough.
    \Drupal::classResolver(ConfigEntityUpdater::class)
      ->update($sandbox, 'agreement');
    return t('Updated all agreements.');
  }
  return NULL;
}

/**
 * Changes frequency type from "integer" to "float".
 */
function agreement_post_update_update_frequency_type(&$sandbox = NULL) {
  if (\Drupal::moduleHandler()->moduleExists('agreement')) {
    \Drupal::classResolver(ConfigEntityUpdater::class)
      ->update($sandbox, 'agreement');
    return t('Updated all agreements');
  }
  return NULL;
}
