var Ahah = Ahah || {};

/**
 *  element binding - object definition
 *  id: id attribute of the element
 *  class: class attribute for collection of elements (optional)
 *  event: the type of event being bound to (click, change, etc)
 *  form_id: encapslating form
 *  path: the Drupal uri to call to get the updating html
 *  wrapper: the id of the container to insert the updated html into
 *  params: hash of params to be send back to the uri (overwrites form values)
 */
 
/**
 * new idea: function binding
 * allow for js -> js communication of existing bindings
 * key: jQuery selector (such as #id or input.class)
 * function: callback to function to be attached (and reattached) to that key
 * example from collapse.js-example:
 *		Drupal.settings.ahah.functions = Drupal.settings.ahah.functions || [];
 *      Drupal.settings.ahah.functions.push( {
 *			key: 'fieldset.collapsible > legend', 
 *			function: Drupal.attachCollapsible 
 *      } );
 */
 
/**
 * Utility Function for copying objects
 */
Ahah.cloneObject = function(what) {
    for (i in what) {
        this[i] = what[i];
    }
}
 
/**
 * Do an Asynchronous call back to Drupal to regenerate the wrapper and swap out the old content.
 */
Ahah.update = function( element ) {
//	console.log( "Updating " + element.id + ", " + element.event );
//	console.log( "Element " + $('#' + element.id).name() + ", " + $('#' + element.id).val() );
	
	$('body').attr("style", "cursor:wait");
	
	// build the params to post back to drupal as array of objects
    var params = $( '#' + element.form_id ).formToArray( true ); // collect the form's parameters
	for( var key in element.params ) {
	    params.push( {name: key, value: element.params[key]} );
	} 
	// push the name/value of the activated element into the params
	if( element.event == 'click' ) {
		params.push( {name: $('#' + element.id).name(), value: $('#' + element.id).val()} );
    }
        
//    console.log( params );
        
    basePath = Drupal.settings.ahah.basePath[0];
    uri = basePath + element.path;
	wrapper_id = '#' + element.wrapper;
		
	$.post( uri, params, function(data) {
		$(wrapper_id).html( data ); // replace the old content
		$(wrapper_id).Highlight(1000, '#ff8'); // yellow flash
		// re-attach event listeners to newly generated html
		Ahah.attach_all_bindings( element.wrapper );
		$('body').attr("style", "cursor:auto");
	} );
}

Ahah.attach_to_element = function(element, wrapper) {
	if( element.class ) {
		key = 'input.' + element.class;
	}
	else {
		key = '#' + element.id;
	}
	
	// only effect elements inside of wrapper, if wrapper is set (if not, just do entire page)
	if( wrapper ) {
		key = '#' + wrapper + ' ' + key;
	}	
	
//	console.log( "Attach_to_element:  " + key + " : " + wrapper );
	
	$(key).each( function() {
	    var el = new Ahah.cloneObject( element ); //same basic element, different ids (for binding class)
	  	el.id = this.id;

//		console.log( "Attaching:  " + el.id + " : " + el.event + " (" + el.wrapper +")" );
		if( element.event == 'click' ) {
			$(this).click( function() {Ahah.update( el ); return false;} );
		}
		else if( element.event == 'change' ) {
			$(this).change( function() {Ahah.update( el ); return false;} );
		}
		//$(id).bind( el.event, el, Ahah.update ); jquery 1.1 version
  	} );
} 

Ahah.attach_function = function(binding, wrapper) {
  		key = binding.key;
  		if( wrapper ) {
  			key = wrapper + ' ' + binding.key;
  		}
//		console.log( "Binding :  " + key + " to: " + binding.function ); 
  		$(key).each( binding.function );
}


/**
 *  Attach listeners to all elements
 */
Ahah.attach_all_bindings = function( wrapper ) {
	// Drupal.ahah.elements is an array of arrays of elements
	for (var i in Drupal.settings.ahah.bindings ) {
		for (var j in Drupal.settings.ahah.bindings[i] ) {
  			element = Drupal.settings.ahah.bindings[i][j];
  			Ahah.attach_to_element( element, wrapper );
  		}
  	}
  	
	// Drupal.ahah.functions is one-d array of bindings
  	for (var i in Drupal.settings.ahah.functions) {
  		binding = Drupal.settings.ahah.functions[i];
  		Ahah.attach_function( binding, wrapper );
  	}
}

if( Drupal.jsEnabled ) {
	$(document).ready(Ahah.attach_all_bindings);
}