<?php

namespace Drupal\ahrefs\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Session\AccountInterface;

/**
 * Matomo onpage metrics form: allows users to configure the modal settings and content.
 */
class AhrefsSettingsForm extends ConfigFormBase {

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames() {
    return [
      'ahrefs.settings',
    ];
  }

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'ahrefs_config_form';
  }

  /**
   * Implements \Drupal\Core\Form\FormInterface::access().
   */
  public function access(AccountInterface $account, $return_as_object = FALSE) {
    $access = $account->hasPermission('administer ahrefs');
    return $return_as_object ? AccessResult::allowedIf($access)->cachePerPermissions() : $access;
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    $config = $this->config('ahrefs.settings');

    $form['data_key'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Ahrefs Data Key'),
      '#description' => $this->t('Enter the data-key for the Ahrefs analytics script.'),
      '#default_value' => $config->get('data_key') ?? '',
      '#required' => TRUE,
    ];

    $form['data_cookieconsent'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Enable Cookie Consent'),
      '#description' => $this->t('Add the data-cookieconsent="analytics" attribute to the script.'),
      '#default_value' => $config->get('data_cookieconsent') ?? FALSE,
    ];

    return parent::buildForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    parent::submitForm($form, $form_state);

    $this->config('ahrefs.settings')
      ->set('data_key', $form_state->getValue('data_key'))
      ->set('data_cookieconsent', $form_state->getValue('data_cookieconsent'))
      ->save();
  }

}
