# Ahrefs Script Module

## Overview
The Ahrefs Script module is a custom Drupal module that allows you to include the Ahrefs analytics script on your website. It provides configurable options to manage the script’s `data-key` and an optional `data-cookieconsent="analytics"` attribute.

For a full description of the module, visit the
[project page](https://www.drupal.org/project/ahrefs).

Submit bug reports and feature suggestions, or track changes in the
[issue queue](https://www.drupal.org/project/issues/ahrefs).

---

## Features
- Add the Ahrefs analytics script to your site.
- Configure the `data-key` via the admin interface.
- Enable or disable the `data-cookieconsent="analytics"` attribute through an optional setting. (for Cookiebot)

---

## Installation

Install as you would normally install a contributed Drupal module. Visit:
[Installing Drupal Modules](https://www.drupal.org/docs/extending-drupal/installing-drupal-modules) for further information.

---

## Configuration

1. Go to **Configuration > System > Ahrefs Script Settings**.
2. Enter the required `data-key` provided by Ahrefs.
3. (Optional) Check the **Enable Cookie Consent** option to include the `data-cookieconsent="analytics"` attribute in the script.
4. Save the settings.

---

## Script Output
The module dynamically generates the following script tag based on the configuration:

- If the **Enable Cookie Consent** option is checked:
  ```html
  <script src="https://analytics.ahrefs.com/analytics.js" data-key="your-configured-data-key" data-cookieconsent="analytics" async></script>
  ```

- If the **Enable Cookie Consent** option is unchecked:
  ```html
  <script src="https://analytics.ahrefs.com/analytics.js" data-key="your-configured-data-key" async></script>
  ```

---

## Support
If you encounter any issues or have questions, please create a issue.
[issue queue](https://www.drupal.org/project/issues/ahrefs)

