# Contribute Bug Reports

This section covers how you can contribute by finding bugs in the AI module. Finding and reporting bugs is essential for maintaining the quality and stability of the AI module, especially given its complexity and the rapid pace of development in the AI field.

## Reporting Bugs
Please contribute bugs in our [issue queue](https://www.drupal.org/project/issues/ai?categories=All). When you find a bug, create a new issue with a detailed description of the problem, including steps to reproduce it, expected behavior, and actual behavior. The more information you provide, the easier it will be for maintainers to understand and fix the issue.

If you are uncertain if something is a bug or not, still please create an issue. The maintainers will review it and determine if it is indeed a bug or if it is expected behavior.

Any bug found that proves to be a real bug will always be credited to the bug finder, even without a merge request. This means that if you find a bug and report it, you will be recognized for your contribution, even if you do not know how to fix it or do not have the time to create a merge request.

## Bug Fixing
If you are able to fix a bug, please create a merge request with your changes. Check [Developer Information](developer_information.md) for guidelines on how to contribute code, including coding standards, testing, and documentation requirements.

## Testing Bug Fixes
If someone has a MR set in review and you have the time to test it, please do so. Testing bug fixes is crucial to ensure that the fix works as intended and does not introduce new issues. If you find that the bug is still present after the fix, please comment on the merge request with your findings and feel free to set it RTBC (Reviewed and Tested By Community) if you think it is ready for merging. This helps maintainers prioritize and merge fixes more efficiently and you will be credited for your testing efforts.
