# Contribute Features

While we have a fairly clear roadmap set out by the maintainers and the [Drupal AI Initiative](https://new.drupal.org/ai/announcement), we are always open to new features that can enhance the AI module and its submodules

## Start by creating a feature ticket
Since features can be quite complex and may require discussion, we recommend starting by creating a feature ticket in the [AI Issue queue](https://www.drupal.org/project/issues/ai?categories=All). This allows you to outline your proposed feature, gather feedback from the community, and ensure that it aligns with the overall goals of the AI module.

Even a good feature issue that is implemented by someone else will be credited to the person who created the feature issue. This means that if you propose a feature and someone else implements it, you will still receive recognition for your contribution.

Please do understand that not all features will be accepted, as we have a limited amount of time and resources to maintain the AI module or if they are features that are not aligned with the goals of the AI module. However, we encourage you to propose features that you believe will benefit the community and enhance the AI module's capabilities.

Since the AI module is a core framework, if you have a feature that you believe is better suited as a contributed module, please feel free to create a contributed module instead. We are always open to new ideas and contributions that can help improve the AI ecosystem in Drupal.

## Feature Implementation
If you are interested in implementing a feature, please follow the [Developer Information](developer_information.md) section for guidelines on how to contribute code, including coding standards, testing, and documentation requirements.

We encourage you to create a merge request with your feature implementation once you have completed it. The maintainers will review your code, provide feedback, and merge it into the main branch if it meets the requirements and aligns with the goals of the AI module.

## Helping out with features on the roadmap
Search the [AI Issue queue](https://www.drupal.org/project/issues/ai?categories=All) for issues tagged with `Feature request` or `Roadmap`. These issues represent features that the maintainers have identified as important for the AI module's development. If you see a feature that interests you, feel free to assign yourself to it and start working on it.

If you are unsure about the implementation details or need guidance, please reach out in the [AI-contrib Slack channel](https://www.drupal.org/slack) or create a comment on the issue. The community is active and supportive, and you can get help from other contributors and maintainers.
