# Release Management

These pages will document the release management process for the AI module, including how to package it, generate release notes, and publish the release.

| Title | Description |
|-------|-------------|
| [General Rules & Timing](general_rules.md) | The general rules and timelines for releases, including when to release, how often, and any special considerations. This also includes information about the current person/team responsible for releases. |
| [Versioning](versioning.md) | Outlines versioning the AI module, including how to increment version numbers based on the type of release (patch, minor, major, security) and any special considerations for versioning. |
| [Tagging a Release](tagging_a_release.md) | Covers steps required to package a new release of the AI module, including updating version numbers, generating release notes, creating the tag in the version control system, and how to revert a release if necessary. This documentation is true for any type of release (patch, minor, major, security). |
| [Publishing a Patch Release](publishing_a_patch_release.md) | Steps required to publish a patch release of the AI module. This process is smaller in scope than a full release, but we still want verification steps to ensure quality. This also covers both regular Wednesday patch releases as well as critical bug fix releases that may happen outside of the normal schedule. |
| [Publishing a Minor/Major Release](publishing_a_minor_major_release.md) | Steps required to publish a minor or major release of the AI module. This process is larger in scope than a patch release, and includes additional verification and testing steps to ensure quality. |
| [Publishing a Security Release](publishing_a_security_release.md) | Steps required to publish a security release of the AI module. This process is similar to a patch release, but includes additional steps to ensure that the security vulnerability is properly addressed, communicated and published earlier for the security team to review. |
| [Release Notes](release_notes.md) | How to write release notes for the AI module, including guidelines on what to include, formatting, and examples of good release notes. |
| [Breaking Changes](release_notes.md) | When there is breaking change that requires documented upgrade paths, this outlines how to communicate it properly. |
