# Request UX Support for AI modules

## Requesting a UX Review

The Drupal AI UX team provides reviews and guidance for contributed modules in the AI ecosystem. Whether you need help with naming, labeling, interface layouts, or user flows, you can request support through our review process.

## Submitting a Review Request

To request a UX review, add the **Needs UX review** tag to any issue within the Drupal AI ecosystem. 
When creating your issue, include the following information:

- **Module version** and any relevant submodules installed  
- **URL path** where the issue occurs (e.g., `/admin/config/ai/settings`)  
- **Screenshots** of the current interface  
- **Description** of the problem and expected behavior  
- **Video walkthrough** for complex interactions (optional but helpful)  
- **Tag Issue:** Add “Needs UX review”

Complete information helps us respond faster. Issues with missing key details will be returned for clarification before review begins.

**UX Review Timeline:** You can expect an initial acknowledgment of your issue within 3 business days. Simple issues are often resolved within a week. Complex issues are reviewed at the weekly Monday meeting and may take longer depending on scope and team availability.

### What Happens Next

**Daily triage** — The AI UX/QA team scans for new UX-tagged issues each day. We check that the required information is present and assess whether the issue is straightforward or needs deeper discussion.

**Simple issues** are assigned directly to an available UX team member who will provide feedback or recommendations on the issue.

**Complex issues** are flagged for the weekly UX planning meeting (Mondays), where the team reviews them together, prioritizes against the existing backlog, and assigns owners.

## Resolution

Once assigned, the UX team member will:

- Review the issue and provide feedback, recommendations, or design solutions  
- Update the issue with their findings  
- Document the work for visibility and contribution credit

You will receive a notification on drupal.org when your issue is updated.

## How It Works

![Flowchart showing the UX review process: Developers submit issues tagged "Needs UX review" with required information. The UX/QA Support Team performs daily triage, assesses complexity, and either assigns simple issues directly to team members or flags complex issues for discussion. The full UX Team works on assigned tasks, collaborates via Slack or working sessions, reviews complex issues at weekly Monday meetings, and updates issues with recommendations before marking them done.](https://git.drupalcode.org/project/ai/-/wikis/uploads/1317258ecea377d7816ecb53db7b099c/diagram_issues_tagged_needs_ux_review-optimized.png)

## Getting Help
If you have questions about the review process or want to discuss an issue before submitting, reach out on the #ai-ux Slack channel.
