# Communicating a Release

After a release is published, it should be announced on Slack to keep contributors and users informed.

## Steps

1. In Slack, ensure you have *Format messages with markup* enabled in your preferences:
   > File > Preferences > Advanced > *Format messages with markup*

2. Construct the Slack message using the following template in Markdown:
   ```md
   Drupal AI Module version [1.1.9](https://drupal.org/i/3568791) and [1.2.6](https://drupal.org/i/3568792) has been released :rocket: ... Highlights:
   - [#3554510](https://drupal.org/i/3554510): Sync Design of Toolbar Chatbot with Canvas AI Chatbot
   - [#3566310](https://drupal.org/i/3566310): AI Provider Test Scenario Documentation
   - [#3567649](https://drupal.org/i/3567649): Add possibility to configure a provider without an API Key
   - Amount of contributors: 31 :muscle:
   - Amount of organizations: 18 :house_buildings:
   - Amount of issues: 17 :rolled_up_newspaper:
   ```

3. Update the highlights, reflecting the changes that had the most involvement or impact for the release

4. Ensure the links and numbers are reflected to represent the latest version

5. Optionally, be creative about the emoji usage to reflect the feeling of the release

6. In Slack, post the message to [`#ai-contrib`](https://drupal.slack.com/archives/C0803LX4536), ensuring the format is correct

7. Forward the post to [`#ai-initiative-dev`](https://drupal.slack.com/archives/C08V00HJDDM), mentioning [@pdjohnson](https://www.drupal.org/u/pdjohnson) for marketing visibility.
