# UX Improvement Projects

Larger UX initiatives, such as new features, interface redesigns, or cross-module improvements, follow a structured project lifecycle. This process ensures alignment across the team and produces well-documented, tested deliverables.

## Project Selection

The UX team maintains a backlog of planned projects. Projects are selected based on priority, available resources, and alignment with ecosystem goals (such as upcoming Drupal CMS releases).

Once a project is selected, the Product Manager, in collaboration with the Product Owner, assembles a team that typically includes a UX designer, UX researcher and relevant developers.

## Phase 1: Discovery

Every project begins with a **kickoff meeting** that brings together the Product Manager, UX designer/researcher, and the broader UX team. The goal is to align on scope early and gather input from people familiar with different parts of the system.

During discovery, the team:

- **Defines scope** - What problem are we solving? What's in and out of scope?  
- **Documents user journeys** - How do users currently accomplish this task?  
- **Captures existing UI** - Screenshots of current interfaces for reference

These deliverables are reviewed at the weekly UX meeting. The team discusses the approach and decides whether to proceed to design.

## Phase 2: Design

Once the discovery phase is approved, design work begins.

**Wireframes** are created first to establish layout, information hierarchy, and interaction patterns. These are added to the shared Figma board and reviewed at the weekly meeting.

If the project requires visual design work (custom styling, new UI, illustrations), **mockups** are created after wireframes are approved. Projects without custom styling may skip mockups and move directly to development.

## Phase 3: Development

With approved designs in hand, the project is assigned to a developer or development team. The developer builds the feature while referencing the wireframes and mockups.

During development, a **UX evaluation** is conducted by the UX designer and/or researcher to verify that the implementation aligns with the intended design and user experience.

## Phase 4: Quality Assurance

Once development is complete, the feature enters QA review:

- QA team tests the implementation against requirements  
- Issues are logged and addressed  
- The QA/fix cycle continues until the feature passes

When QA passes, the feature is tagged for release and shipped.

## Weekly Checkpoints

Each phase includes a review at the weekly UX meeting (Mondays). This keeps projects moving, surfaces blockers early, and ensures the broader team has visibility into progress.

Projects that don't receive approval at a checkpoint return to the previous phase for revision before proceeding.

## How It Works

![Flowchart showing the UX project lifecycle across five roles: Product Manager selects projects from the backlog and assigns a team. UX Researcher leads a kickoff meeting to define scope, document user journeys, and capture existing UI screenshots, then reviews the approach at weekly meetings. UX Designer creates wireframes in Figma, reviews at weekly meetings, creates mockups if creative work is needed, and conducts UX evaluation with the researcher. Developers work on the feature and request QA review. QA performs testing - if it fails, work returns to development; if it passes, the release is tagged and the feature ships.](https://git.drupalcode.org/project/ai/-/wikis/uploads/2c9534a82df483b7a2c69a56da946720/diagram_ux_project_lifecycle.png)