(function ($) {
  let timeout;
  $(document).on('ready', function (timeout) {
    // Prevent enter.
    $('#edit-filter').on('keypress', function (e) {
      if (e.keyCode === 13) {
        e.preventDefault();
      }
    });
    $('#edit-filter').on('keyup', function (e) {
      // Enter key should do nothing.
      if (e.keyCode === 13) {
        e.preventDefault();
        return;
      }
      // Make sure that the timeout is cleared.
      if (timeout) {
        clearTimeout(timeout);
      }
      // Make sure to debounce 500ms.
      timeout = setTimeout(function () {
        let filter = $('#edit-filter').val().toLowerCase();
        $('.tool-wrapper').each(function () {
          // Get the data-id attribute value.
          let id = $(this).data('id');
          // Check if the data-id attribute value contains the filter value.
          if (id.indexOf(filter) > -1) {
            $(this).show();
          } else {
            $(this).hide();
          }
        });
      }, 500);
    });
  });
})(jQuery);
