# drupal/ai_agents_chatbot_evaluation_recipe

This is a recipe that downloads the [AI module](https://www.drupal.org/project/ai), [AI Agents](https://www.drupal.org/project/ai_agents) and [AI Evaluations](https://www.drupal.org/project/ai_evaluations), together with the OpenAI and Anthropic provider. It provides a setup Chatbot as soon as you have filled in one of the API keys under /admin/config/ai/providers.

## Install

#### 1. Add the recipe part to your composer.json
Unless you have done this already, add the following into your composer.json to make sure the recipes are placed correctly.

```bash
"installer-paths": {
 // existing entries omitted...
 "web/recipes/contrib/{$name}": [
   "type:drupal-recipe"
 ]
}
```

#### 2. Get this recipe.
Run the following to download the recipe:

```bash
composer require drupal/ai_agents_chatbot_evaluation_recipe
```

#### 3. Download dependencies and apply the recipe.
Run the following two commands to download all the dependencies from this recipe and then apply it.

```
composer install
drush recipe recipes/contrib/ai_agents_chatbot_evaluation_recipe
```

#### 4. Setup API Keys
You need to login to your website and setup one of the OpenAI or Anthropic keys under /admin/config/ai/providers.
