# AI Automator Pixabay

## What is this

AI Automator Pixabay is an extension module for the AI Automator in the [AI module](https://www.drupal.org/project/ai) that exposes two new automators to make it possible to automate the seeding galleries or header images from the Pixabay stock image directory.

The automators are pretty simple - they take a search word and searches Pixabay for this and fetches the amount of images that you want. These then gets filled in either an image or media field.

Note that this supersedes the AI Interpolator Pixabay for Drupal 10.3+ with the AI Automator module.

For more information on how to use the AI Automator (previously AI Interpolator), check https://workflows-of-ai.com.

## Features
* Take a search word (that can have been generated in a chain) and create one or many images or medias from it.

## Requirements
* Requires an account at [Pixabay](https://developers.google.com/maps/documentation/places/web-service/overview).
* Requires the [Media Pixabay](https://www.drupal.org/project/media_pixabay) module.
* Requires the AI Automator submodule of the [AI module](https://www.drupal.org/project/ai) project.

## How to use as AI Automator type
1. Install the [AI Automator module](https://www.drupal.org/project/ai) and the [Media Pixabay](https://www.drupal.org/project/media_pixabay) module.
2. Install this module.
3. Visit /admin/config/media/pixabay and add your api keys from your Pixabay account.
4. Create some entity or node type with a simple text field.
5. Create an [address](https://www.drupal.org/project/address) field.
6. Enable AI Automator checkbox and configure it.
7. Create an entity of the type you generated, fill in some search words and save.
8. The address field be filled out.

## Sponsors
This module was supported by FreelyGive (https://freelygive.io/), your partner in Drupal AI.
