## AI CKEditor WCAG Module

### Overview
The **AI CKEditor WCAG** module extends the functionality of the **Drupal AI** and **AI CKEditor** modules. It provides a plugin for the CKEditor that integrates with an AI provider to analyze and detect WCAG (Web Content Accessibility Guidelines) compliance issues in content. This module is particularly useful for ensuring accessibility and improving the overall quality of web content.

---

### Features
- **CKEditor Plugin**: Seamlessly integrates into the CKEditor interface to allow content creators to check for WCAG compliance issues directly while editing.
- **AI-Powered Analysis**: Utilizes an AI provider to identify potential WCAG problems in real-time.
- **User-Friendly Reporting**: Displays detailed feedback on WCAG violations and suggestions for improvement within the editor.

---

### Requirements
- **Drupal Core**: Version 10.x or higher
- **Drupal AI Module**
- **AI CKEditor Module**

---

### Installation
1. Download and install the **AI CKEditor WCAG** module like you would install any Drupal module.
2. Ensure the **Drupal AI** and **AI CKEditor** modules are installed and enabled.

---

### Configuration
1. **Enable the plugin**:
   - In the Text formatting and editors section (/site/admin/config/content/formats) you can enable this plugin for any desired text editor format.
2. **Customize WCAG Rules**:
   - Select the LLM. The selection is generated according to the selected AI provider in the AI module.
   - Select the specific WCAG guidelines version and level to be checked (e.g., Version 1.0, 2.0, 2.1, 2.2 and Level A, AA, AAA).

---

### Usage
1. Open any content editing form with the CKEditor enabled.
2. Use the AI CKEditor WCAG plugin in the toolbar to analyze the content.
3. Review the results displayed within the editor and make the necessary corrections.

---

Thank you for using the AI CKEditor WCAG module. Let’s make the web more accessible for everyone!
