<?php

namespace Drupal\Tests\ai_eca_agents\Kernel;

use Drupal\Component\Serialization\Json;
use Drupal\KernelTests\KernelTestBase;
use Drupal\node\Entity\NodeType;

/**
 * Base class for Kernel-tests regarding AI ECA Agents.
 */
abstract class AiEcaAgentsKernelTestBase extends KernelTestBase {

  /**
   * {@inheritdoc}
   */
  protected static $modules = [
    'ai_eca',
    'ai_eca_agents',
    'eca',
    'eca_base',
    'eca_content',
    'eca_test_model_cross_ref',
    'eca_user',
    'field',
    'node',
    'text',
    'token',
    'user',
    'serialization',
    'schemata',
    'schemata_json_schema',
    'system',
  ];

  /**
   * Generate different sets of data payloads.
   *
   * @return \Generator
   *   Returns a collection of data payloads.
   */
  public static function payloadProvider(): \Generator {
    yield [
      Json::decode(file_get_contents(sprintf('%s/../../assets/from_payload_0.json', __DIR__))),
      [
        'events' => 1,
        'conditions' => 0,
        'actions' => 5,
        'label' => 'Create Article on Page Publish',
      ],
    ];

    yield [
      Json::decode(file_get_contents(sprintf('%s/../../assets/from_payload_1.json', __DIR__))),
      [],
      NULL,
      'model_id: This value should not be null',
    ];

    yield [
      Json::decode(file_get_contents(sprintf('%s/../../assets/from_payload_2.json', __DIR__))),
      [],
      NULL,
      'events: This value should not be null',
    ];

    yield [
      Json::decode(file_get_contents(sprintf('%s/../../assets/from_payload_3.json', __DIR__))),
      [
        'events' => 1,
        'conditions' => 1,
        'gateways' => 1,
        'actions' => 3,
        'label' => 'Create Article on New Page',
      ],
    ];

    yield [
      Json::decode(file_get_contents(sprintf('%s/../../assets/from_payload_3.json', __DIR__))),
      [
        'events' => 1,
        'conditions' => 1,
        'gateways' => 1,
        'actions' => 3,
        'label' => 'Create Article on New Page',
        'version' => 'v1',
      ],
      'eca_test_0001',
    ];

    yield [
      Json::decode(file_get_contents(sprintf('%s/../../assets/from_payload_4.json', __DIR__))),
      [],
      NULL,
      "Invalid successor ID 'condition_check_title' for Event 'event_page_published'. Must reference a gateway or action.",
    ];
  }

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();

    $this->installEntitySchema('eca');
    $this->installEntitySchema('node');
    $this->installEntitySchema('user');

    $this->installConfig(static::$modules);

    // Create the Page content type with a standard body field.
    /** @var \Drupal\node\NodeTypeInterface $node_type */
    $node_type = NodeType::create(['type' => 'page', 'name' => 'Page']);
    $node_type->save();
    node_add_body_field($node_type);

    // Create the Article content type with a standard body field.
    /** @var \Drupal\node\NodeTypeInterface $node_type */
    $node_type = NodeType::create(['type' => 'article', 'name' => 'Article']);
    $node_type->save();
    node_add_body_field($node_type);
  }

}
