<?php

namespace Drupal\Tests\ai_eca_agents\Kernel;

use Drupal\ai_eca_agents\Schema\Eca as EcaSchema;
use Drupal\ai_eca_agents\TypedData\EcaModelDefinition;
use Drupal\KernelTests\KernelTestBase;
use Spatie\Snapshots\MatchesSnapshots;
use Symfony\Component\Serializer\SerializerInterface;

/**
 * Kernel test for the ECA Model data type.
 *
 * @group ai_eca_agents
 */
class EcaModelSchemaTest extends KernelTestBase {

  use MatchesSnapshots;

  /**
   * {@inheritdoc}
   */
  protected static $modules = [
    'ai_eca',
    'ai_eca_agents',
    'eca',
    'serialization',
    'schemata',
    'schemata_json_schema',
    'system',
    'token',
    'user',
  ];

  /**
   * The serializer.
   *
   * @var \Symfony\Component\Serializer\SerializerInterface|null
   */
  protected ?SerializerInterface $serializer;

  /**
   * Validates the generated schema of the Eca Model data type.
   */
  public function testSchema(): void {
    $definition = EcaModelDefinition::create();
    $schema = new EcaSchema($definition, $definition->getPropertyDefinitions());
    $schema = $this->serializer->serialize($schema, 'schema_json:json', []);

    $this->assertMatchesJsonSnapshot($schema);
  }

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();

    $this->installEntitySchema('user');

    $this->installConfig(static::$modules);

    $this->serializer = $this->container->get('serializer');
  }

}
