(function (Drupal, drupalSettings) {
  'use strict';

  Drupal.behaviors.deepchatEvaluations = {
    attach: function (context, settings) {
      document.addEventListener('DrupalDeepchatInitialized', function (event) {
        for (let chat of event.detail.chats) {
          // Add the event for voting and the styles.
          chat.htmlClassUtilities = {
              'evaluations-button': {
                events: { click: (event) => {
                  event.preventDefault();
                  let clickedVote = event.target.closest('.ai-evaluation-vote');
                  let url = clickedVote.href;
                  // Send the vote to the server.
                  fetch(url, {
                  }).then((response) => {
                    let parent = clickedVote.parentNode;
                    let siblings = parent.childNodes;
                    let currentSibling = siblings.length;
                    while(currentSibling--) {
                      if (siblings[currentSibling].classList && siblings[currentSibling].classList.contains('ai-evaluation-vote')) {
                        parent.removeChild(siblings[currentSibling]);
                      }
                    }
                    parent.innerHTML += '<small class="chat-message-evaluation chat-message-evaluation--voted">Your evaluation has been logged.</small>';
                  });
                }
              },
            }
          }
        }
      });
    }
  }
})(Drupal, drupalSettings);
