<?php

namespace Drupal\ai_evaluations;

use Drupal\Core\Entity\EntityInterface;
use Drupal\Core\Entity\EntityListBuilder;

/**
 * Defines a class to build a listing of AI Evaluation Type entities.
 */
class AiEvaluationTypeListBuilder extends EntityListBuilder {

  /**
   * {@inheritdoc}
   */
  public function buildHeader() {
    $header['label'] = $this->t('AI Evaluation Type');
    $header['id'] = $this->t('Machine name');
    return $header + parent::buildHeader();
  }

  /**
   * {@inheritdoc}
   */
  public function buildRow(EntityInterface $entity) {
    /** @var \Drupal\ai_evaluations\Entity\AiEvaluationType $entity */
    // Display the label.
    $row['label'] = $entity->label();
    // Display the machine name.
    $row['id'] = $entity->id();
    return $row + parent::buildRow($entity);
  }

}
