<?php

namespace Drupal\ai_evaluations\Entity;

use Drupal\Core\Config\Entity\ConfigEntityBundleBase;

/**
 * Defines the AI Evaluation Type entity.
 *
 * @ConfigEntityType(
 *   id = "ai_evaluation_type",
 *   label = @Translation("AI Evaluation Type"),
 *   bundle_of = "ai_evaluation",
 *   entity_keys = {
 *     "id" = "id",
 *     "label" = "label",
 *     "uuid" = "uuid",
 *   },
 *   config_prefix = "ai_evaluation_type",
 *   config_export = {
 *     "id",
 *     "label",
 *   },
 *   handlers = {
 *     "form" = {
 *       "default" = "Drupal\ai_evaluations\Form\AiEvaluationTypeForm",
 *       "add" = "Drupal\ai_evaluations\Form\AiEvaluationTypeForm",
 *       "edit" = "Drupal\ai_evaluations\Form\AiEvaluationTypeForm",
 *       "delete" = "Drupal\Core\Entity\EntityDeleteForm",
 *     },
 *     "route_provider" = {
 *       "html" = "Drupal\Core\Entity\Routing\AdminHtmlRouteProvider",
 *     },
 *     "list_builder" = "Drupal\ai_evaluations\AiEvaluationTypeListBuilder",
 *     "view_builder" = "Drupal\Core\Entity\EntityViewBuilder",
 *     "field_ui" = "Drupal\field_ui\Entity\EntityFormDisplay",
 *   },
 *   admin_permission = "administer ai_evaluation",
 *   links = {
 *     "canonical" = "/admin/config/ai/evaluations/types/{ai_evaluation_type}",
 *     "add-form" = "/admin/config/ai/evaluations/types/add",
 *     "edit-form" = "/admin/config/ai/evaluations/types/{ai_evaluation_type}/edit",
 *     "delete-form" = "/admin/config/ai/evaluations/types/{ai_evaluation_type}/delete",
 *     "collection" = "/admin/config/ai/evaluations/types",
 *   }
 * )
 */
class AiEvaluationType extends ConfigEntityBundleBase {
}
