<?php

namespace Drupal\ai_evaluations\Form;

use Drupal\Core\Entity\EntityStorageException;
use Drupal\Core\Form\FormBase;
use Drupal\Core\Form\FormStateInterface;

class EvaluationsImportForm extends FormBase {

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'ai_evaluations.import';
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    $form['file'] = [
      '#type' => 'file',
      '#title' => $this->t('Import file'),
      '#extensions' => ['csv'],
    ];
    $form['submit'] = [
      '#type' => 'submit',
      '#value' => $this->t('Import'),
    ];

    return $form;
  }

  public function validateForm(array &$form, FormStateInterface $form_state) {
    parent::validateForm($form, $form_state);

    $all_files = $this->getRequest()->files->get('files', []);
    if (!empty($all_files['file'])) {
      $file_upload = $all_files['file'];
      if ($file_upload->isValid()) {
        $form_state->setValue('file', $file_upload->getRealPath());
        return;
      }
    }

    $form_state->setErrorByName('file', $this->t('The file could not be uploaded.'));
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    if ($path = $form_state->getValue('file')) {
      $file = fopen($path, 'r');
      $header = fgetcsv($file, 0, ',');
      while(($row = fgetcsv($file, 0, ','))) {
        foreach ($row as $delta => $value) {
          if (in_array($header[$delta], ['messages', 'model_config'])) {
            $values[$header[$delta]] = (array) json_decode(base64_decode($value));
            continue;
          }
          $values[$header[$delta]] = unserialize(base64_decode($value));
        }
        try {
          \Drupal::entityTypeManager()
            ->getStorage('ai_evaluation')
            ->create($values)
            ->save();
        }
        catch (EntityStorageException $e) {
          // This is probably because the entity with this UUID already exists
          // so do nothing and continue.
        }
      }
    }
  }

}
