<?php

namespace Drupal\ai_evaluations\Plugin\Field\FieldFormatter;

use Drupal\Core\Field\Attribute\FieldFormatter;
use Drupal\Core\Field\FieldItemListInterface;
use Drupal\Core\Field\FormatterBase;
use Drupal\Core\StringTranslation\ByteSizeMarkup;
use Drupal\Core\StringTranslation\TranslatableMarkup;

/**
 * Formatter that renders all messages from an AI Evaluation.
 */
#[FieldFormatter(
  id: 'ai_comparison',
  label: new TranslatableMarkup('AI Comparison'),
  field_types: [
    'integer',
  ],
)]
class Comparison extends FormatterBase {

  /**
   * {@inheritdoc}
   */
  public function viewElements(FieldItemListInterface $items, $langcode) {
    $elements = [];

    foreach ($items as $delta => $item) {
      $elements[$delta] = ['#markup' => $item->value];
    }

    return $elements;
  }

}
