<?php

declare(strict_types=1);

namespace Drupal\ai_evaluations\Routing;

use Drupal\ai_evaluations\Controller\Evaluations;
use Drupal\Core\Entity\EntityTypeInterface;
use Drupal\Core\Entity\Routing\AdminHtmlRouteProvider;

/**
 * Provides HTML routes for entities with administrative pages.
 */
final class AIEvaluationHtmlRouteProvider extends AdminHtmlRouteProvider {

  /**
   * {@inheritdoc}
   */
  protected function getCanonicalRoute(EntityTypeInterface $entity_type) {
    $route = parent::getCanonicalRoute($entity_type);
    $defaults = $route->getDefaults();
    unset($defaults['_entity_view']);
    $defaults['_controller'] = Evaluations::class . '::evaluation';
    $route->setDefaults($defaults);
    $params = $route->getOption('parameters');
    $route->setOption('parameters', $params + [
      'ai_assistant' => ['type' => 'entity:ai_assistant'],
    ]);
    return $route;
  }

}
