<?php

namespace Drupal\Tests\ai_integration_eca_agents\Kernel;

use Drupal\ai_integration_eca_agents\Services\EcaRepository\EcaRepositoryInterface;

/**
 * Tests various input data for generating ECA models.
 *
 * @group ai_integration_eca_agents
 */
class EcaRepositoryTest extends AiEcaAgentsKernelTestBase {

  /**
   * The ECA repository.
   *
   * @var \Drupal\ai_integration_eca_agents\Services\EcaRepository\EcaRepositoryInterface|null
   */
  protected ?EcaRepositoryInterface $ecaRepository;

  /**
   * Build an ECA-model with the provided data.
   *
   * @dataProvider payloadProvider
   */
  public function testBuildModel(array $data, array $assertions, ?string $id = NULL, ?string $errorMessage = NULL): void {
    if (!empty($errorMessage)) {
      $this->expectExceptionMessage($errorMessage);
    }

    $eca = $this->ecaRepository->build($data, TRUE, $id);

    foreach ($assertions as $property => $expected) {
      switch (TRUE) {
        case is_int($expected):
          $this->assertCount($expected, $eca->get($property));
          break;

        case is_string($expected):
          $this->assertEquals($expected, $eca->get($property));
          break;
      }
    }
  }

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();

    $this->ecaRepository = \Drupal::service('ai_integration_eca_agents.services.eca_repository');
  }

}
