<?php

namespace Drupal\ai_integration_eca_agents\Services\ModelMapper;

use Drupal\ai_integration_eca_agents\Plugin\DataType\EcaModel;
use Drupal\eca\Entity\Eca;

/**
 * Interface that describes a model mapper.
 */
interface ModelMapperInterface {

  /**
   * Map a payload to the ECA Model typed data.
   *
   * @param array $payload
   *   The external payload.
   *
   * @return \Drupal\ai_integration_eca_agents\Plugin\DataType\EcaModel
   *   Returns the ECA Model typed data.
   */
  public function fromPayload(array $payload): EcaModel;

  /**
   * Map an ECA-entity to the ECA Model typed data.
   *
   * @param \Drupal\eca\Entity\Eca $entity
   *   The ECA entity.
   *
   * @return \Drupal\ai_integration_eca_agents\Plugin\DataType\EcaModel
   *   Returns the ECA Model typed data.
   */
  public function fromEntity(Eca $entity): EcaModel;

}
