<?php

namespace Drupal\ai_interpolator;

use Drupal\Core\Entity\ContentEntityInterface;
use Drupal\Core\Template\TwigEnvironment;

/**
 * Helps replacing prompts.
 */
class AiPromptHelper {

  /**
   * The twig environment.
   */
  protected TwigEnvironment $twig;

  /**
   * Constructs a new AiInterpolatorRuleRunner object.
   *
   * @param \Drupal\Core\Template\TwigEnvironment $twig
   *   Twig environment.
   */
  public function __construct(TwigEnvironment $twig) {
    $this->twig = $twig;
  }

  /**
   * Render a prompt.
   *
   * @var string $prompt
   *   The prompt.
   * @var array $tokens
   *   The placeholders.
   *
   * @return string
   *   The rendered twig.
   */
  public function renderPrompt($prompt, array $tokens) {
    // Get variables.
    $template = $this->twig->createTemplate(htmlspecialchars_decode($prompt));
    return $template->render($tokens);
  }

  /**
   * Render a tokenized prompt.
   *
   * @var string $prompt
   *   The prompt.
   * @var \Drupal\Core\Entity\ContentEntityInterface $entity
   *   The entity.
   *
   * @return string
   *   The rendered prompt.
   */
  public function renderTokenPrompt($prompt, ContentEntityInterface $entity) {
    // Get variables.
    return \Drupal::token()->replace($prompt, [
      $entity->getEntityTypeId() => $entity,
      'user' => \Drupal::currentUser(),
    ]);
  }

}