<?php

namespace Drupal\Tests\ai_interpolator\Unit;

use Drupal\ai_interpolator\AiFieldRules;
use Drupal\ai_interpolator\AiInterpolatorRuleRunner;
use Drupal\ai_interpolator\Annotation\AiInterpolatorFieldRule;
use Drupal\ai_interpolator\Exceptions\AiInterpolatorRuleNotFoundException;
use Drupal\Core\Entity\ContentEntityInterface;
use Drupal\Core\Entity\EntityTypeManager;
use Drupal\Core\Field\FieldDefinitionInterface;
use Drupal\Core\Template\TwigEnvironment;
use Drupal\Tests\UnitTestCase;

/**
 * @coversDefaultClass \Drupal\ai_interpolator\AiInterpolatorRuleRunner
 * @group ai_interpolator
 */
class AiInterpolatorRuleRunnerTest extends UnitTestCase {

  /**
   * The Rule Runner under test.
   */
  protected AiInterpolatorRuleRunner $ruleRunner;

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    $entityTypeManager = $this->getMockBuilder(EntityTypeManager::class)
      ->disableOriginalConstructor()
      ->getMock();
    $twig = $this->getMockBuilder(TwigEnvironment::class)
      ->disableOriginalConstructor()
      ->getMock();
    $aiFieldRules = $this->getMockBuilder(AiFieldRules::class)
      ->disableOriginalConstructor()
      ->getMock();
    $aiFieldRules
      ->method('findRule')
      ->will($this->returnCallback(
        function ($ruleName) {
          if ($ruleName == 'string') {
            $rule = $this->getMockBuilder(AiInterpolatorFieldRule::class)
              ->disableOriginalConstructor()
              ->getMock();
            $rule
              ->method('generateTokens')
              ->willReturn(
                [
                  'token1' => 'hello',
                ]
              );
            return $rule;
          }
          return NULL;
        }
      )
    );

    $this->ruleRunner = new AiInterpolatorRuleRunner($entityTypeManager, $twig, $aiFieldRules);
  }

  /**
   * Test a rule that can't be found.
   */
  public function testFaultyRule(): void {
    $contentEntity = $this->getMockBuilder(ContentEntityInterface::class)
      ->disableOriginalConstructor()
      ->getMock();

    $fieldDefinition = $this->getMockBuilder(FieldDefinitionInterface::class)
      ->disableOriginalConstructor()
      ->getMock();
    $fieldDefinition
      ->method('getType')
      ->willReturn('none_existing');
    $interpolatorConfig = [
      'rule' => 'none_exisiting',
    ];
    $this->expectException(AiInterpolatorRuleNotFoundException::class);
    $this->expectExceptionMessage('The rule could not be found: none_existing');
    $this->ruleRunner->generateResponse($contentEntity, $fieldDefinition, $interpolatorConfig);
  }

}
