<?php
namespace Drupal\ai_story_teller;

use Drupal\Core\Entity\EntityInterface;
use Drupal\Core\Entity\EntityListBuilder;

/**
 * Provides a list controller for the ai reporter content entity type.
 */
final class AiRContentListBuilder extends EntityListBuilder {

  /**
   * {@inheritdoc}
   */
  public function buildHeader(): array {
    $header['id'] = $this->t('ID');
    $header['label'] = $this->t('Label');
    $header['profile'] = $this->t('Profile');
    $header['source'] = $this->t('Source');
    $header['created'] = $this->t('Created');
    return $header + parent::buildHeader();
  }

  /**
   * {@inheritdoc}
   */
  public function buildRow(EntityInterface $entity): array {
    /** @var AiRContentInterface $entity */
    $row['id'] = $entity->id();
    $row['label'] = $entity->label();
    $row['profile'] = $entity->get('profile')->getValue()[0]['value'];
    $row['source'] = $entity->get('source')->getValue()[0]['value'];
    $row['created']['data'] = $entity->get('created')->view(['label' => 'hidden']);
    return $row + parent::buildRow($entity);
  }
}
