<?php

namespace Drupal\ai_story_teller;

use Drupal\Core\Plugin\DefaultPluginManager;

/**
 * Manages discovery and instantiation of AI Reporter Scraper plugins.
 */
class AiRScraperPluginManager extends DefaultPluginManager {

  /**
   * Constructs a new AiReporterScraperPluginManager.
   *
   * @param \Traversable $namespaces
   *   An object that contains the root paths keyed by the corresponding namespace.
   * @param \Drupal\Core\Cache\CacheBackendInterface $cache_backend
   *   Cache backend instance to use.
   * @param \Drupal\Core\Extension\ModuleHandlerInterface $module_handler
   *   The module handler to invoke the alter hook with.
   */
  public function __construct(\Traversable $namespaces, $cache_backend, $module_handler) {
    parent::__construct('Plugin/AiReporterScraper', $namespaces, $module_handler, 'Drupal\ai_story_teller\Plugin\AiRScraperPluginInterface', 'Drupal\ai_story_teller\Annotation\AiRScraperPlugin');
    $this->alterInfo('ai_reporter_scraper_plugin_info');
    $this->setCacheBackend($cache_backend, 'ai_reporter_scraper_plugins');
  }

}
