<?php

namespace Drupal\ai_story_teller\Entity;

use Drupal\Core\Config\Entity\ConfigEntityBase;

/**
 * Defines the profile entity type.
 *
 * @ConfigEntityType(
 *   id = "profile",
 *   label = @Translation("AI Story Teller Profile"),
 *   label_collection = @Translation("AI Story Teller Profiles"),
 *   label_singular = @Translation("profile"),
 *   label_plural = @Translation("profiles"),
 *   label_count = @PluralTranslation(
 *     singular = "@count profile",
 *     plural = "@count profiles",
 *   ),
 *   handlers = {
 *     "list_builder" = "Drupal\ai_story_teller\ProfileListBuilder",
 *     "form" = {
 *       "add" = "Drupal\ai_story_teller\Form\ProfileForm",
 *       "edit" = "Drupal\ai_story_teller\Form\ProfileForm",
 *       "delete" = "Drupal\Core\Entity\EntityDeleteForm",
 *     },
 *   },
 *   config_prefix = "profile",
 *   admin_permission = "administer profile",
 *   links = {
 *     "collection" = "/admin/structure/profile",
 *     "add-form" = "/admin/structure/profile/add",
 *     "edit-form" = "/admin/structure/profile/{profile}",
 *     "delete-form" = "/admin/structure/profile/{profile}/delete",
 *   },
 *   entity_keys = {
 *     "id" = "id",
 *     "label" = "label",
 *     "uuid" = "uuid",
 *   },
 *   config_export = {
 *     "id",
 *     "label",
 *     "sources",
 *     "prompt_template",
 *     "reports_storage",
 *     "provider_settings",
 *     "status"
 *   },
 * )
 */
final class Profile extends ConfigEntityBase {

  /**
   * The Profile ID.
   *
   * @var string
   */
  protected $id;

  /**
   * The Profile label.
   *
   * @var string
   */
  protected $label;

  /**
   * The Profile status.
   *
   * @var bool
   */
  protected $status;

  /**
   * The sources.
   *
   * @var array
   */
  protected $sources = [];

  /**
   * The prompt template.
   *
   * @var string
   */
  protected $prompt_template;

  /**
   * The reports storage.
   *
   * @var array
   */
  protected $reports_storage = [];

  /**
   * The provider settings.
   *
   * @var array
   */
  protected $provider_settings = [];

  public function getProviderSettings() {
    if (!empty($this->provider_settings) && is_string($this->provider_settings)) {
      return json_decode($this->provider_settings);
    }
    return NULL;
  }

}

