<?php

declare(strict_types=1);

namespace Drupal\ai_story_teller\Entity;

use Drupal\ai_story_teller\SourceInterface;
use Drupal\Core\Config\Entity\ConfigEntityBase;

/**
 * Defines the source entity type.
 *
 * @ConfigEntityType(
 *   id = "source",
 *   label = @Translation("Source"),
 *   label_collection = @Translation("Sources"),
 *   label_singular = @Translation("source"),
 *   label_plural = @Translation("sources"),
 *   label_count = @PluralTranslation(
 *     singular = "@count source",
 *     plural = "@count sources",
 *   ),
 *   handlers = {
 *     "list_builder" = "Drupal\ai_story_teller\SourceListBuilder",
 *     "form" = {
 *       "add" = "Drupal\ai_story_teller\Form\SourceForm",
 *       "edit" = "Drupal\ai_story_teller\Form\SourceForm",
 *       "delete" = "Drupal\Core\Entity\EntityDeleteForm",
 *     },
 *   },
 *   config_prefix = "source",
 *   admin_permission = "administer source",
 *   links = {
 *     "collection" = "/admin/structure/source",
 *     "add-form" = "/admin/structure/source/add",
 *     "edit-form" = "/admin/structure/source/{source}",
 *     "delete-form" = "/admin/structure/source/{source}/delete",
 *   },
 *   entity_keys = {
 *     "id" = "id",
 *     "label" = "label",
 *     "uuid" = "uuid",
 *   },
 *   config_export = {
 *     "id",
 *     "label",
 *     "url",
 *     "scraper_plugin"
 *   },
 * )
 */
final class Source extends ConfigEntityBase {

  /**
   * The source ID.
   */
  protected string $id;

  /**
   * The source label.
   */
  protected string $label;

  /**
   * The source url.
   */
  protected string $url;

  /**
   * Scraper plugin.
   */
  protected string $scraper_plugin;

}
