<?php

namespace Drupal\ai_story_teller\Plugin;

use Symfony\Component\DomCrawler\Crawler;
use Drupal\Component\Plugin\PluginBase;
use Drupal\Core\Plugin\ContainerFactoryPluginInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;
use GuzzleHttp\ClientInterface;

/**
 * Base class for AI Reporter Scraper plugins.
 */
abstract class AiRScraperPluginBase extends PluginBase implements AiRScraperPluginInterface, ContainerFactoryPluginInterface {

  /**
   * The Symfony DomCrawler instance.
   *
   * @var \Symfony\Component\DomCrawler\Crawler
   */
  protected $crawler;

  /**
   * The HTTP client service.
   *
   * @var \GuzzleHttp\ClientInterface
   */
  protected $httpClient;

  /**
   * Constructs a new AiReporterScraperPluginBase.
   *
   * @param array $configuration
   *   The configuration array.
   * @param string $plugin_id
   *   The plugin ID.
   * @param mixed $plugin_definition
   *   The plugin definition.
   * @param \Symfony\Component\DomCrawler\Crawler $crawler
   *   The Symfony DomCrawler service.
   * @param \GuzzleHttp\ClientInterface $http_client
   *   The HTTP client service.
   */
  public function __construct(array $configuration, $plugin_id, $plugin_definition, Crawler $crawler, ClientInterface $http_client) {
    parent::__construct($configuration, $plugin_id, $plugin_definition);
    $this->crawler = $crawler;
    $this->httpClient = $http_client;
  }

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container, array $configuration, $plugin_id, $plugin_definition) {
    return new static(
      $configuration,
      $plugin_id,
      $plugin_definition,
      $container->get('ai_reporter.dom_crawler'),
      $container->get('http_client')
    );
  }

  /**
   * {@inheritdoc}
   */
  abstract public function scrape($url): array;

}
