<?php

namespace Drupal\ai_story_teller\Plugin;

use Drupal\Component\Plugin\PluginInspectionInterface;

/**
 * Defines an interface for AI Reporter Scraper plugins.
 */
interface AiRScraperPluginInterface extends PluginInspectionInterface {

  /**
   * Scrapes the given URL.
   *
   * @param string $url
   *   The URL of the source to be scraped.
   *
   * @return array
   *   An array of scraped data objects.
   */
  public function scrape($url): array;
}
