<?php

namespace Drupal\ai_story_teller\Plugin\AiReporterScraper;

use DateTime;
use Drupal\ai_story_teller\Plugin\AiRScraperPluginBase;
use Drupal\ai_story_teller\Annotation\AiRScraperPlugin;

/**
 * Provides a Title Scraper.
 *
 * @AiRScraperPlugin(
 *   id = "ipn_scraper",
 *   label = @Translation("IPN Scraper")
 * )
 *
 * */
class IpnScraper extends AiRScraperPluginBase {

  /**
   * {@inheritdoc}
   */
  public function scrape($url): array {
    $request = $this->httpClient->request('POST', $url);
    $response = json_decode($request->getBody()->getContents());

    $data = [];
    foreach ($response->results as $item) {

      // get full body
      $url = 'https://www.interpressnews.ge/ka/api/article/' . $item->id;
      $single_request = $this->httpClient->request('POST', $url);
      $single_response = json_decode($single_request->getBody()->getContents());

      $data[] = [
        'label' => $single_response->title,
        'body' => $single_response->fulltext,
        'published' => $single_response->pub_dt,
        'url' => 'https://www.interpressnews.ge' . $single_response->url,
      ];
    }

    return $data;
  }
}
