<?php

namespace Drupal\ai_story_teller\Plugin\AiReporterScraper;

use Drupal\ai_story_teller\Plugin\AiRScraperPluginBase;
use Symfony\Component\DomCrawler\Crawler;

/**
 * Provides a Title Scraper.
 *
 * @AiRScraperPlugin(
 *   id = "onge_scraper",
 *   label = @Translation("On.ge Scraper")
 * )
 *
 * */
class OngeScraper extends AiRScraperPluginBase {

  /**
   * {@inheritdoc}
   */
  public function scrape($url): array {
    $hrefs = [];
    $this->crawler->clear();
    if ($content = $this->httpClient->get($url)) {
      $content = $content->getBody()->getContents();
      $this->crawler->addContent($content);

      if ($parentDiv = $this->crawler->filter('.col-xs-12.listing-equal-grid > ul')) {
        if ($items = $parentDiv->filter('li')) {
          $hrefs = $items->each(function(Crawler $node, $i) {
            $links = $node->filter('span a');
            return $links->each(function(Crawler $linkNode) {
              $href = $linkNode->attr('href');
              return $href;
            });
          });
        }
      }
    }

    $data = [];
    if (count($hrefs) > 0) {
      foreach ($hrefs as $href) {
        try {
          if ($content = $this->httpClient->get($href[0])) {
            $content = $content->getBody()->getContents();
            $this->crawler->clear();
            $this->crawler->addContent($content);

            $title = $this->crawler->filter('h1.article-title');
            $body = $this->crawler->filter('div.article-body');
            $published = $this->crawler->filter('time.onge-date');

            if ($title && $body && $published) {
              $data[] = [
                'label' => $title->text(),
                'body' => $body->html(),
                'published' => $published->attr('datetime'),
                'url' => $href[0],
              ];
            }
          }
        }
        catch (\Exception $exception) {
        }
      }
    }

    return $data;
  }

}
