<?php

namespace Drupal\ai_story_teller\Plugin\AiReporterScraper;

use Drupal\ai_story_teller\Plugin\AiRScraperPluginBase;
use Symfony\Component\DomCrawler\Crawler;

/**
 * Provides Publika Scraper.
 *
 * @AiRScraperPlugin(
 *   id = "publika_scraper",
 *   label = @Translation("Publika Scraper")
 * )
 */
class PublikaScraper extends AiRScraperPluginBase {

  /**
   * {@inheritdoc}
   */
  public function scrape($url): array {
    $hrefs = [];
    $this->crawler->clear();
    if ($content = $this->httpClient->get($url)) {
      $content = $content->getBody()->getContents();
      $this->crawler->addContent($content);

      $hrefs = $this->crawler->filter('.wi-news-list-box .wi-news-list-title a')
        ->each(function(Crawler $node) {
          return $node->attr('href');
        });
    }

    $data = [];
    if (count($hrefs) > 0) {
      foreach ($hrefs as $href) {
        try {
          if ($content = $this->httpClient->get($href)) {
            $content = $content->getBody()->getContents();
            $this->crawler->clear();
            $this->crawler->addContent($content);

            $title = $this->crawler->filter('h1.wi-article-title');
            $body = $this->crawler->filter('div.wi-article-content');
            $published = $this->crawler->filter('time.wi-news-author-date');

            if ($title && $body && $published) {
              $date = new \Datetime();
              $data[] = [
                'label' => $title->text(),
                'body' => $body->html(),
                'published' => $date->format('Y-m-d H:i:s'),
                'url' => $href,
              ];
            }
          }
        }
        catch (\Exception $exception) {
        }
      }
    }

    return $data;
  }

}
