<?php

declare(strict_types=1);

namespace Drupal\ai_story_teller;

use Drupal\Core\Config\Entity\ConfigEntityListBuilder;
use Drupal\Core\Entity\EntityInterface;

/**
 * Provides a listing of sources.
 */
final class SourceListBuilder extends ConfigEntityListBuilder {

  /**
   * {@inheritdoc}
   */
  public function buildHeader(): array {
    $header['label'] = $this->t('Label');
    $header['url'] = $this->t('URL');
    return $header + parent::buildHeader();
  }

  /**
   * {@inheritdoc}
   */
  public function buildRow(EntityInterface $entity): array {
    /** @var \Drupal\ai_story_teller\SourceInterface $entity */
    $row['label'] = $entity->label();
    $row['url'] = $entity->get('url');
    return $row + parent::buildRow($entity);
  }

}
