(function ($, Drupal) {
  Drupal.behaviors.aiSearchBlockLog = {
    attach(context, settings) {
      const $suffixText = $('#ai-search-block-response .suffix_text');
      let $logId;

      $('.ai_search_block_log_score').each(function (index) {
        $(this).on('click', function () {
          const $score = $(this).data('aiSearchBlockLogScore');
          if (
            typeof drupalSettings.ai_search_block !== 'undefined' &&
            typeof drupalSettings.ai_search_block.logId !== 'undefined'
          ) {
            $logId = drupalSettings.ai_search_block.logId;
          }
          if (
            typeof drupalSettings.ai_talk_with_node !== 'undefined' &&
            typeof drupalSettings.ai_talk_with_node.logId !== 'undefined'
          ) {
            $logId = drupalSettings.ai_talk_with_node.logId;
          }
          // Var $logId = $(this).parent().find('[data-drupal-selector="edit-node-id"]').val().
          const jqxhr = $.post(
            '/ai-search-block-log/score',
            {
              log_id: $logId,
              score: $score,
            },
            function (data) {
              $suffixText.html(data.response);
              Drupal.attachBehaviors($suffixText[0]);
              $suffixText.show();
            },
          )
            .done(function () {
              // alert( "second success" );
            })
            .fail(function () {
              // alert( "error" );
            })
            .always(function () {
              // alert( "finished" );
            });
          jqxhr.always(function () {
            // alert( "second finished" );
          });
        });
      });
    },
  };
})(jQuery, Drupal);
